<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Brand;
use App\Models\MobileModel;

class BrandsAndModelsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $tenantId = 1; // Default tenant ID, adjust as needed

        // Phone Brands and Models (2015-2025)
        $phoneModels = [
            'Apple' => [
                // iPhones (2015-2025)
                'iPhone 6s', 'iPhone 6s Plus', 'iPhone SE (1st gen)', 'iPhone 7', 'iPhone 7 Plus',
                'iPhone 8', 'iPhone 8 Plus', 'iPhone X', 'iPhone XR', 'iPhone XS', 'iPhone XS Max',
                'iPhone 11', 'iPhone 11 Pro', 'iPhone 11 Pro Max', 'iPhone SE (2nd gen)',
                'iPhone 12 mini', 'iPhone 12', 'iPhone 12 Pro', 'iPhone 12 Pro Max',
                'iPhone 13 mini', 'iPhone 13', 'iPhone 13 Pro', 'iPhone 13 Pro Max',
                'iPhone SE (3rd gen)', 'iPhone 14', 'iPhone 14 Plus', 'iPhone 14 Pro', 'iPhone 14 Pro Max',
                'iPhone 15', 'iPhone 15 Plus', 'iPhone 15 Pro', 'iPhone 15 Pro Max',
                'iPhone 16', 'iPhone 16 Plus', 'iPhone 16 Pro', 'iPhone 16 Pro Max'
            ],
            'Samsung' => [
                // Galaxy S Series (2015-2025)
                'Galaxy S6', 'Galaxy S6 Edge', 'Galaxy S6 Edge+', 'Galaxy S7', 'Galaxy S7 Edge',
                'Galaxy S8', 'Galaxy S8+', 'Galaxy S9', 'Galaxy S9+', 'Galaxy S10e', 'Galaxy S10', 'Galaxy S10+',
                'Galaxy S20', 'Galaxy S20+', 'Galaxy S20 Ultra', 'Galaxy S21', 'Galaxy S21+', 'Galaxy S21 Ultra',
                'Galaxy S22', 'Galaxy S22+', 'Galaxy S22 Ultra', 'Galaxy S23', 'Galaxy S23+', 'Galaxy S23 Ultra',
                'Galaxy S24', 'Galaxy S24+', 'Galaxy S24 Ultra', 'Galaxy S25', 'Galaxy S25+', 'Galaxy S25 Ultra',
                // Galaxy Note Series
                'Galaxy Note 5', 'Galaxy Note 7', 'Galaxy Note 8', 'Galaxy Note 9', 'Galaxy Note 10', 'Galaxy Note 10+',
                'Galaxy Note 20', 'Galaxy Note 20 Ultra',
                // Galaxy A Series
                'Galaxy A10', 'Galaxy A12', 'Galaxy A13', 'Galaxy A14', 'Galaxy A15', 'Galaxy A20', 'Galaxy A21',
                'Galaxy A22', 'Galaxy A23', 'Galaxy A24', 'Galaxy A25', 'Galaxy A30', 'Galaxy A31', 'Galaxy A32',
                'Galaxy A33', 'Galaxy A34', 'Galaxy A35', 'Galaxy A50', 'Galaxy A51', 'Galaxy A52', 'Galaxy A53',
                'Galaxy A54', 'Galaxy A55', 'Galaxy A70', 'Galaxy A71', 'Galaxy A72', 'Galaxy A73', 'Galaxy A74',
                // Galaxy Z Series (Foldables)
                'Galaxy Z Fold', 'Galaxy Z Fold 2', 'Galaxy Z Fold 3', 'Galaxy Z Fold 4', 'Galaxy Z Fold 5', 'Galaxy Z Fold 6',
                'Galaxy Z Flip', 'Galaxy Z Flip 3', 'Galaxy Z Flip 4', 'Galaxy Z Flip 5', 'Galaxy Z Flip 6'
            ],
            'Google' => [
                // Pixel Series (2016-2025)
                'Pixel', 'Pixel XL', 'Pixel 2', 'Pixel 2 XL', 'Pixel 3', 'Pixel 3 XL', 'Pixel 3a', 'Pixel 3a XL',
                'Pixel 4', 'Pixel 4 XL', 'Pixel 4a', 'Pixel 4a 5G', 'Pixel 5', 'Pixel 5a',
                'Pixel 6', 'Pixel 6 Pro', 'Pixel 6a', 'Pixel 7', 'Pixel 7 Pro', 'Pixel 7a',
                'Pixel 8', 'Pixel 8 Pro', 'Pixel 8a', 'Pixel 9', 'Pixel 9 Pro', 'Pixel 9 Pro XL',
                'Pixel Fold', 'Pixel Fold 2'
            ],
            'OnePlus' => [
                // OnePlus Models (2015-2025)
                'OnePlus 2', 'OnePlus X', 'OnePlus 3', 'OnePlus 3T', 'OnePlus 5', 'OnePlus 5T',
                'OnePlus 6', 'OnePlus 6T', 'OnePlus 7', 'OnePlus 7 Pro', 'OnePlus 7T', 'OnePlus 7T Pro',
                'OnePlus 8', 'OnePlus 8 Pro', 'OnePlus 8T', 'OnePlus 9', 'OnePlus 9 Pro', 'OnePlus 9R', 'OnePlus 9RT',
                'OnePlus 10 Pro', 'OnePlus 10T', 'OnePlus 11', 'OnePlus 11R', 'OnePlus 12', 'OnePlus 12R',
                'OnePlus Nord', 'OnePlus Nord 2', 'OnePlus Nord 3', 'OnePlus Nord CE', 'OnePlus Nord CE 2',
                'OnePlus Nord CE 3', 'OnePlus Nord N10', 'OnePlus Nord N20', 'OnePlus Nord N30'
            ],
            'Xiaomi' => [
                // Mi Series
                'Mi 4i', 'Mi 5', 'Mi 5s', 'Mi 5s Plus', 'Mi 6', 'Mi 6X', 'Mi 8', 'Mi 8 SE', 'Mi 9', 'Mi 9T', 'Mi 9T Pro',
                'Mi 10', 'Mi 10 Pro', 'Mi 10T', 'Mi 10T Pro', 'Mi 11', 'Mi 11 Pro', 'Mi 11 Ultra',
                // Redmi Series
                'Redmi Note 4', 'Redmi Note 5', 'Redmi Note 6 Pro', 'Redmi Note 7', 'Redmi Note 8', 'Redmi Note 9',
                'Redmi Note 10', 'Redmi Note 11', 'Redmi Note 12', 'Redmi Note 13', 'Redmi Note 14',
                'Redmi 9', 'Redmi 10', 'Redmi 11', 'Redmi 12', 'Redmi 13', 'Redmi 14',
                // Poco Series
                'Poco F1', 'Poco F2 Pro', 'Poco F3', 'Poco F4', 'Poco F5', 'Poco F6',
                'Poco X2', 'Poco X3', 'Poco X4 Pro', 'Poco X5 Pro', 'Poco X6 Pro'
            ],
            'Huawei' => [
                // P Series
                'P8', 'P9', 'P10', 'P20', 'P20 Pro', 'P30', 'P30 Pro', 'P40', 'P40 Pro', 'P50', 'P50 Pro', 'P60', 'P60 Pro',
                // Mate Series
                'Mate 8', 'Mate 9', 'Mate 10', 'Mate 10 Pro', 'Mate 20', 'Mate 20 Pro', 'Mate 30', 'Mate 30 Pro',
                'Mate 40', 'Mate 40 Pro', 'Mate 50', 'Mate 50 Pro', 'Mate 60', 'Mate 60 Pro',
                // Nova Series
                'Nova', 'Nova 2', 'Nova 3', 'Nova 4', 'Nova 5', 'Nova 6', 'Nova 7', 'Nova 8', 'Nova 9', 'Nova 10', 'Nova 11'
            ],
            'Oppo' => [
                // Find Series
                'Find X', 'Find X2', 'Find X3', 'Find X5', 'Find X6', 'Find X7',
                // Reno Series
                'Reno', 'Reno 2', 'Reno 3', 'Reno 4', 'Reno 5', 'Reno 6', 'Reno 7', 'Reno 8', 'Reno 9', 'Reno 10', 'Reno 11',
                // A Series
                'A5', 'A9', 'A15', 'A16', 'A17', 'A31', 'A52', 'A53', 'A54', 'A57', 'A58', 'A72', 'A74', 'A76', 'A77', 'A78'
            ],
            'Vivo' => [
                // X Series
                'X6', 'X7', 'X9', 'X20', 'X21', 'X23', 'X27', 'X30', 'X50', 'X60', 'X70', 'X80', 'X90', 'X100',
                // V Series
                'V5', 'V7', 'V9', 'V11', 'V15', 'V17', 'V19', 'V20', 'V21', 'V23', 'V25', 'V27', 'V29', 'V30',
                // Y Series
                'Y15', 'Y17', 'Y19', 'Y20', 'Y21', 'Y22', 'Y27', 'Y31', 'Y33', 'Y35', 'Y36', 'Y55', 'Y56', 'Y72', 'Y73', 'Y75', 'Y77'
            ],
            'Realme' => [
                // Number Series
                'Realme 1', 'Realme 2', 'Realme 3', 'Realme 5', 'Realme 6', 'Realme 7', 'Realme 8', 'Realme 9', 'Realme 10', 'Realme 11', 'Realme 12',
                // GT Series
                'Realme GT', 'Realme GT 2', 'Realme GT 3', 'Realme GT Neo', 'Realme GT Neo 2', 'Realme GT Neo 3',
                // C Series
                'Realme C1', 'Realme C2', 'Realme C3', 'Realme C11', 'Realme C12', 'Realme C15', 'Realme C17', 'Realme C20', 'Realme C21', 'Realme C25',
                'Realme C30', 'Realme C31', 'Realme C33', 'Realme C35', 'Realme C53', 'Realme C55'
            ],
            'LG' => [
                // G Series (2015-2021)
                'G4', 'G5', 'G6', 'G7 ThinQ', 'G8 ThinQ', 'G8X ThinQ',
                // V Series
                'V10', 'V20', 'V30', 'V40 ThinQ', 'V50 ThinQ', 'V60 ThinQ',
                // Wing
                'Wing'
            ],
            'Sony' => [
                // Xperia Series (2015-2025)
                'Xperia Z5', 'Xperia X', 'Xperia XZ', 'Xperia XZ1', 'Xperia XZ2', 'Xperia XZ3',
                'Xperia 1', 'Xperia 1 II', 'Xperia 1 III', 'Xperia 1 IV', 'Xperia 1 V',
                'Xperia 5', 'Xperia 5 II', 'Xperia 5 III', 'Xperia 5 IV', 'Xperia 5 V',
                'Xperia 10', 'Xperia 10 II', 'Xperia 10 III', 'Xperia 10 IV', 'Xperia 10 V'
            ],
            'HTC' => [
                // HTC Models (2015-2019)
                'One M9', 'One A9', 'One X9', '10', 'U11', 'U12+', 'U19e', 'U20 5G', 'Desire 19+', 'Desire 20 Pro', 'Desire 21 Pro'
            ],
            'Motorola' => [
                // Moto G Series
                'Moto G (3rd gen)', 'Moto G4', 'Moto G5', 'Moto G6', 'Moto G7', 'Moto G8', 'Moto G9', 'Moto G10', 'Moto G20', 'Moto G30',
                'Moto G40', 'Moto G50', 'Moto G60', 'Moto G71', 'Moto G72', 'Moto G73', 'Moto G84', 'Moto G85',
                // Moto E Series
                'Moto E (2nd gen)', 'Moto E3', 'Moto E4', 'Moto E5', 'Moto E6', 'Moto E7', 'Moto E13', 'Moto E14',
                // Edge Series
                'Moto Edge', 'Moto Edge+', 'Moto Edge 20', 'Moto Edge 30', 'Moto Edge 40', 'Moto Edge 50'
            ]
        ];

        // Computer/Laptop Brands and Models (2015-2025)
        $computerModels = [
            'Apple' => [
                // MacBook Models (2015-2025)
                'MacBook Air 11" (2015)', 'MacBook Air 13" (2015)', 'MacBook Air 13" (2017)', 'MacBook Air 13" (2018)',
                'MacBook Air 13" (2019)', 'MacBook Air 13" (2020)', 'MacBook Air 13" M1 (2020)', 'MacBook Air 13" M2 (2022)',
                'MacBook Air 15" M2 (2023)', 'MacBook Air 13" M3 (2024)', 'MacBook Air 15" M3 (2024)',
                'MacBook Pro 13" (2015)', 'MacBook Pro 15" (2015)', 'MacBook Pro 13" (2016)', 'MacBook Pro 15" (2016)',
                'MacBook Pro 13" (2017)', 'MacBook Pro 15" (2017)', 'MacBook Pro 13" (2018)', 'MacBook Pro 15" (2018)',
                'MacBook Pro 13" (2019)', 'MacBook Pro 16" (2019)', 'MacBook Pro 13" (2020)', 'MacBook Pro 13" M1 (2020)',
                'MacBook Pro 14" M1 Pro/Max (2021)', 'MacBook Pro 16" M1 Pro/Max (2021)', 'MacBook Pro 13" M2 (2022)',
                'MacBook Pro 14" M2 Pro/Max (2023)', 'MacBook Pro 16" M2 Pro/Max (2023)', 'MacBook Pro 14" M3 (2023)',
                'MacBook Pro 16" M3 (2023)', 'MacBook Pro 14" M4 (2024)', 'MacBook Pro 16" M4 (2024)',
                'MacBook 12" (2015)', 'MacBook 12" (2016)', 'MacBook 12" (2017)',
                // iMac Models
                'iMac 21.5" (2015)', 'iMac 27" (2015)', 'iMac 21.5" (2017)', 'iMac 27" (2017)', 'iMac 21.5" (2019)',
                'iMac 27" (2019)', 'iMac 27" (2020)', 'iMac 24" M1 (2021)', 'iMac 24" M3 (2023)', 'iMac 24" M4 (2024)',
                // Mac Mini
                'Mac Mini (2014)', 'Mac Mini (2018)', 'Mac Mini M1 (2020)', 'Mac Mini M2 (2023)', 'Mac Mini M4 (2024)',
                // Mac Pro
                'Mac Pro (2013)', 'Mac Pro (2019)', 'Mac Pro M2 Ultra (2023)',
                // Mac Studio
                'Mac Studio M1 Max/Ultra (2022)', 'Mac Studio M2 Max/Ultra (2023)'
            ],
            'Dell' => [
                // XPS Series
                'XPS 13 (2015)', 'XPS 13 (2016)', 'XPS 13 (2017)', 'XPS 13 (2018)', 'XPS 13 (2019)', 'XPS 13 (2020)',
                'XPS 13 (2021)', 'XPS 13 (2022)', 'XPS 13 (2023)', 'XPS 13 (2024)', 'XPS 13 (2025)',
                'XPS 15 (2015)', 'XPS 15 (2016)', 'XPS 15 (2017)', 'XPS 15 (2018)', 'XPS 15 (2019)', 'XPS 15 (2020)',
                'XPS 15 (2021)', 'XPS 15 (2022)', 'XPS 15 (2023)', 'XPS 15 (2024)', 'XPS 15 (2025)',
                'XPS 17 (2020)', 'XPS 17 (2021)', 'XPS 17 (2022)', 'XPS 17 (2023)', 'XPS 17 (2024)',
                // Inspiron Series
                'Inspiron 15 3000', 'Inspiron 15 5000', 'Inspiron 15 7000', 'Inspiron 13 5000', 'Inspiron 13 7000',
                'Inspiron 14 3000', 'Inspiron 14 5000', 'Inspiron 14 7000', 'Inspiron 17 3000', 'Inspiron 17 5000',
                // Latitude Series
                'Latitude 7390', 'Latitude 7400', 'Latitude 7410', 'Latitude 7420', 'Latitude 7430', 'Latitude 9410',
                'Latitude 9420', 'Latitude 9430', 'Latitude 5420', 'Latitude 5430', 'Latitude 5520', 'Latitude 5530',
                // Gaming Series
                'G3 15', 'G3 17', 'G5 15', 'G5 17', 'G7 15', 'G7 17', 'Alienware m15', 'Alienware m17', 'Alienware x15', 'Alienware x17'
            ],
            'HP' => [
                // Pavilion Series
                'Pavilion 15', 'Pavilion 14', 'Pavilion 13', 'Pavilion x360 13', 'Pavilion x360 14', 'Pavilion x360 15',
                'Pavilion Gaming 15', 'Pavilion Gaming 16', 'Pavilion Gaming 17',
                // Envy Series
                'Envy 13', 'Envy 15', 'Envy 17', 'Envy x360 13', 'Envy x360 15', 'Envy x360 17',
                // Spectre Series
                'Spectre x360 13', 'Spectre x360 15', 'Spectre x360 16', 'Spectre 13', 'Spectre 14',
                // EliteBook Series
                'EliteBook 830 G5', 'EliteBook 840 G5', 'EliteBook 850 G5', 'EliteBook 830 G6', 'EliteBook 840 G6',
                'EliteBook 850 G6', 'EliteBook 830 G7', 'EliteBook 840 G7', 'EliteBook 850 G7', 'EliteBook 830 G8',
                'EliteBook 840 G8', 'EliteBook 850 G8', 'EliteBook 830 G9', 'EliteBook 840 G9', 'EliteBook 850 G9',
                // Gaming Series
                'Omen 15', 'Omen 16', 'Omen 17', 'Victus 15', 'Victus 16'
            ],
            'Lenovo' => [
                // ThinkPad Series
                'ThinkPad X1 Carbon (Gen 3)', 'ThinkPad X1 Carbon (Gen 4)', 'ThinkPad X1 Carbon (Gen 5)', 'ThinkPad X1 Carbon (Gen 6)',
                'ThinkPad X1 Carbon (Gen 7)', 'ThinkPad X1 Carbon (Gen 8)', 'ThinkPad X1 Carbon (Gen 9)', 'ThinkPad X1 Carbon (Gen 10)',
                'ThinkPad X1 Carbon (Gen 11)', 'ThinkPad X1 Carbon (Gen 12)',
                'ThinkPad X1 Extreme (Gen 1)', 'ThinkPad X1 Extreme (Gen 2)', 'ThinkPad X1 Extreme (Gen 3)', 'ThinkPad X1 Extreme (Gen 4)',
                'ThinkPad X1 Extreme (Gen 5)',
                'ThinkPad T14', 'ThinkPad T14s', 'ThinkPad T15', 'ThinkPad T16', 'ThinkPad E14', 'ThinkPad E15', 'ThinkPad E16',
                'ThinkPad P1', 'ThinkPad P14s', 'ThinkPad P15', 'ThinkPad P16', 'ThinkPad Z13', 'ThinkPad Z16',
                // IdeaPad Series
                'IdeaPad 3 14"', 'IdeaPad 3 15"', 'IdeaPad 5 14"', 'IdeaPad 5 15"', 'IdeaPad 5 Pro 14"', 'IdeaPad 5 Pro 16"',
                'IdeaPad Flex 5 14"', 'IdeaPad Flex 5 15"', 'IdeaPad Gaming 3 15"', 'IdeaPad Gaming 3 17"',
                // Legion Series
                'Legion 5 15"', 'Legion 5 17"', 'Legion 5 Pro 16"', 'Legion 7 15"', 'Legion 7 16"', 'Legion Y540', 'Legion Y740',
                'Legion Slim 5 16"', 'Legion Slim 7 16"', 'Legion Pro 5 16"', 'Legion Pro 7 16"'
            ],
            'ASUS' => [
                // ZenBook Series
                'ZenBook 13 UX325', 'ZenBook 13 UX333', 'ZenBook 14 UX425', 'ZenBook 14 UX434', 'ZenBook 15 UX525',
                'ZenBook Pro 14', 'ZenBook Pro 15', 'ZenBook Pro 16X', 'ZenBook Flip 13', 'ZenBook Flip 14', 'ZenBook Flip 15',
                // VivoBook Series
                'VivoBook 14', 'VivoBook 15', 'VivoBook 17', 'VivoBook S14', 'VivoBook S15', 'VivoBook Pro 14', 'VivoBook Pro 15',
                'VivoBook Flip 14', 'VivoBook Go 14', 'VivoBook Go 15',
                // ROG Series
                'ROG Zephyrus G14', 'ROG Zephyrus G15', 'ROG Zephyrus M16', 'ROG Zephyrus S17', 'ROG Strix G15', 'ROG Strix G17',
                'ROG Strix Scar 15', 'ROG Strix Scar 17', 'ROG Flow X13', 'ROG Flow X16', 'ROG Ally',
                // TUF Series
                'TUF Gaming A15', 'TUF Gaming A17', 'TUF Gaming F15', 'TUF Gaming F17', 'TUF Dash F15'
            ],
            'Acer' => [
                // Aspire Series
                'Aspire 3', 'Aspire 5', 'Aspire 7', 'Aspire Vero', 'Aspire 1', 'Aspire E15', 'Aspire A315',
                // Swift Series
                'Swift 1', 'Swift 3', 'Swift 5', 'Swift 7', 'Swift X', 'Swift Go 14', 'Swift Go 16',
                // Spin Series
                'Spin 1', 'Spin 3', 'Spin 5', 'Spin 7',
                // Predator Series
                'Predator Helios 300', 'Predator Helios 500', 'Predator Triton 300', 'Predator Triton 500', 'Predator Orion',
                // Nitro Series
                'Nitro 5', 'Nitro 7', 'Nitro 50'
            ],
            'MSI' => [
                // Gaming Series
                'GF63 Thin', 'GF65 Thin', 'GF75 Thin', 'GP66 Leopard', 'GP76 Leopard', 'GE66 Raider', 'GE76 Raider',
                'GS66 Stealth', 'GS76 Stealth', 'GT76 Titan', 'Katana GF66', 'Katana GF76', 'Alpha 15', 'Alpha 17',
                'Bravo 15', 'Bravo 17', 'Crosshair 15', 'Crosshair 17', 'Pulse GL66', 'Pulse GL76',
                // Creator Series
                'Creator Z16', 'Creator Z17', 'Creator 15', 'Creator 17', 'Prestige 14', 'Prestige 15', 'Modern 14', 'Modern 15'
            ],
            'Microsoft' => [
                // Surface Series
                'Surface Pro 4', 'Surface Pro (2017)', 'Surface Pro 6', 'Surface Pro 7', 'Surface Pro 7+', 'Surface Pro 8',
                'Surface Pro 9', 'Surface Pro 10', 'Surface Pro X',
                'Surface Book', 'Surface Book 2', 'Surface Book 3',
                'Surface Laptop (1st Gen)', 'Surface Laptop 2', 'Surface Laptop 3', 'Surface Laptop 4', 'Surface Laptop 5',
                'Surface Laptop Go', 'Surface Laptop Go 2', 'Surface Laptop Go 3',
                'Surface Laptop Studio', 'Surface Laptop Studio 2',
                'Surface Studio', 'Surface Studio 2', 'Surface Studio 2+',
                'Surface Go', 'Surface Go 2', 'Surface Go 3', 'Surface Go 4'
            ]
        ];

        // Insert Phone Brands and Models
        foreach ($phoneModels as $brandName => $models) {
            $brand = Brand::firstOrCreate([
                'name' => $brandName,
                'tenant_id' => $tenantId
            ]);

            foreach ($models as $modelName) {
                MobileModel::firstOrCreate([
                    'brand_id' => $brand->id,
                    'name' => $modelName,
                    'tenant_id' => $tenantId
                ]);
            }
        }

        // Insert Computer Brands and Models
        foreach ($computerModels as $brandName => $models) {
            $brand = Brand::firstOrCreate([
                'name' => $brandName,
                'tenant_id' => $tenantId
            ]);

            foreach ($models as $modelName) {
                MobileModel::firstOrCreate([
                    'brand_id' => $brand->id,
                    'name' => $modelName,
                    'tenant_id' => $tenantId
                ]);
            }
        }

        $this->command->info('Brands and models seeded successfully!');
        $this->command->info('Total brands created: ' . Brand::where('tenant_id', $tenantId)->count());
        $this->command->info('Total models created: ' . MobileModel::where('tenant_id', $tenantId)->count());
    }
}